﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WordNetTools;

namespace SemanticMemory
{
    public class QuestionAnswerer
    {
        //public ShortTermMemory STM;
        public string animalsFeaturesPath;

        public QuestionAnswerer(string animalsFeaturesFilePath)
        {
            //STM = stm;
            animalsFeaturesPath = animalsFeaturesFilePath;
        }

        public string AnswerOrder(string[] question, string wordsResourcePath)
        {
            string order = question[0];
            BasicTools BT = new BasicTools(wordsResourcePath);
            List<string> tmpList = new List<string>(question);
            tmpList.RemoveAt(0);
            question = tmpList.ToArray();
            switch (order)
            {
                case "disambiguate":
                    return BT.AnalyseMeaningsInText(question);
                    break;
                case "paraphrase":
                    return BT.ParaphraseText(question);
                    break;
                case "ask":
                    return BT.AnswerSomething(question);
                    break;
            }
            return "Unknown order";
        }

        public string AnswerDefaultConversation(string[] question, string wordsResourcePath)
        {
            string order = question[0];
            BasicTools BT = new BasicTools(wordsResourcePath);
            return BT.AnswerSomething(question);
        }
    }
}
